package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class Origins(
    quantity: Integer,
    items: Iterable[zio.aws.cloudfront.model.Origin]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.Origins = {
    import Origins.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.Origins
      .builder()
      .quantity(Integer.unwrap(quantity): java.lang.Integer)
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.Origins.ReadOnly =
    zio.aws.cloudfront.model.Origins.wrap(buildAwsValue())
}
object Origins {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.Origins
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.Origins =
      zio.aws.cloudfront.model.Origins(
        quantity,
        items.map { item =>
          item.asEditable
        }
      )
    def quantity: Integer
    def items: List[zio.aws.cloudfront.model.Origin.ReadOnly]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems
        : ZIO[Any, Nothing, List[zio.aws.cloudfront.model.Origin.ReadOnly]] =
      ZIO.succeed(items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.Origins
  ) extends zio.aws.cloudfront.model.Origins.ReadOnly {
    override val quantity: Integer =
      zio.aws.cloudfront.model.primitives.Integer(impl.quantity())
    override val items: List[zio.aws.cloudfront.model.Origin.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.cloudfront.model.Origin.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.Origins
  ): zio.aws.cloudfront.model.Origins.ReadOnly = new Wrapper(impl)
}
