package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateCloudFrontOriginAccessIdentityResponse(
    cloudFrontOriginAccessIdentity: Option[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity
    ] = None,
    location: Option[String] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse = {
    import CreateCloudFrontOriginAccessIdentityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse
      .builder()
      .optionallyWith(
        cloudFrontOriginAccessIdentity.map(value => value.buildAwsValue())
      )(_.cloudFrontOriginAccessIdentity)
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse
      .wrap(buildAwsValue())
}
object CreateCloudFrontOriginAccessIdentityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse =
      zio.aws.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse(
        cloudFrontOriginAccessIdentity.map(value => value.asEditable),
        location.map(value => value),
        eTag.map(value => value)
      )
    def cloudFrontOriginAccessIdentity: Option[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity.ReadOnly
    ]
    def location: Option[String]
    def eTag: Option[String]
    def getCloudFrontOriginAccessIdentity: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudFrontOriginAccessIdentity",
      cloudFrontOriginAccessIdentity
    )
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse
  ) extends zio.aws.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse.ReadOnly {
    override val cloudFrontOriginAccessIdentity: Option[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity.ReadOnly
    ] = scala
      .Option(impl.cloudFrontOriginAccessIdentity())
      .map(value =>
        zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity.wrap(value)
      )
    override val location: Option[String] =
      scala.Option(impl.location()).map(value => value: String)
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse
  ): zio.aws.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse.ReadOnly =
    new Wrapper(impl)
}
