package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OriginRequestPolicyHeadersConfig(
    headerBehavior: zio.aws.cloudfront.model.OriginRequestPolicyHeaderBehavior,
    headers: Option[zio.aws.cloudfront.model.Headers] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeadersConfig = {
    import OriginRequestPolicyHeadersConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeadersConfig
      .builder()
      .headerBehavior(headerBehavior.unwrap)
      .optionallyWith(headers.map(value => value.buildAwsValue()))(_.headers)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.OriginRequestPolicyHeadersConfig.ReadOnly =
    zio.aws.cloudfront.model.OriginRequestPolicyHeadersConfig
      .wrap(buildAwsValue())
}
object OriginRequestPolicyHeadersConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeadersConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.OriginRequestPolicyHeadersConfig =
      zio.aws.cloudfront.model.OriginRequestPolicyHeadersConfig(
        headerBehavior,
        headers.map(value => value.asEditable)
      )
    def headerBehavior
        : zio.aws.cloudfront.model.OriginRequestPolicyHeaderBehavior
    def headers: Option[zio.aws.cloudfront.model.Headers.ReadOnly]
    def getHeaderBehavior: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginRequestPolicyHeaderBehavior
    ] = ZIO.succeed(headerBehavior)
    def getHeaders
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Headers.ReadOnly] =
      AwsError.unwrapOptionField("headers", headers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeadersConfig
  ) extends zio.aws.cloudfront.model.OriginRequestPolicyHeadersConfig.ReadOnly {
    override val headerBehavior
        : zio.aws.cloudfront.model.OriginRequestPolicyHeaderBehavior =
      zio.aws.cloudfront.model.OriginRequestPolicyHeaderBehavior
        .wrap(impl.headerBehavior())
    override val headers: Option[zio.aws.cloudfront.model.Headers.ReadOnly] =
      scala
        .Option(impl.headers())
        .map(value => zio.aws.cloudfront.model.Headers.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeadersConfig
  ): zio.aws.cloudfront.model.OriginRequestPolicyHeadersConfig.ReadOnly =
    new Wrapper(impl)
}
