package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListOriginRequestPoliciesRequest(
    `type`: Option[zio.aws.cloudfront.model.OriginRequestPolicyType] = None,
    marker: Option[String] = None,
    maxItems: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesRequest = {
    import ListOriginRequestPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesRequest
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.String))(
        _.maxItems
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListOriginRequestPoliciesRequest.ReadOnly =
    zio.aws.cloudfront.model.ListOriginRequestPoliciesRequest
      .wrap(buildAwsValue())
}
object ListOriginRequestPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListOriginRequestPoliciesRequest =
      zio.aws.cloudfront.model.ListOriginRequestPoliciesRequest(
        `type`.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def `type`: Option[zio.aws.cloudfront.model.OriginRequestPolicyType]
    def marker: Option[String]
    def maxItems: Option[String]
    def getType
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.OriginRequestPolicyType] =
      AwsError.unwrapOptionField("type", `type`)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesRequest
  ) extends zio.aws.cloudfront.model.ListOriginRequestPoliciesRequest.ReadOnly {
    override val `type`
        : Option[zio.aws.cloudfront.model.OriginRequestPolicyType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.cloudfront.model.OriginRequestPolicyType.wrap(value)
      )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxItems: Option[String] =
      scala.Option(impl.maxItems()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesRequest
  ): zio.aws.cloudfront.model.ListOriginRequestPoliciesRequest.ReadOnly =
    new Wrapper(impl)
}
