package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.FunctionEventObject
import scala.jdk.CollectionConverters._
final case class TestFunctionRequest(
    name: String,
    ifMatch: String,
    stage: Option[zio.aws.cloudfront.model.FunctionStage] = None,
    eventObject: FunctionEventObject
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.TestFunctionRequest = {
    import TestFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.TestFunctionRequest
      .builder()
      .name(name: java.lang.String)
      .ifMatch(ifMatch: java.lang.String)
      .optionallyWith(stage.map(value => value.unwrap))(_.stage)
      .eventObject(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(eventObject.toArray[Byte])
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.TestFunctionRequest.ReadOnly =
    zio.aws.cloudfront.model.TestFunctionRequest.wrap(buildAwsValue())
}
object TestFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.TestFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.TestFunctionRequest =
      zio.aws.cloudfront.model.TestFunctionRequest(
        name,
        ifMatch,
        stage.map(value => value),
        eventObject
      )
    def name: String
    def ifMatch: String
    def stage: Option[zio.aws.cloudfront.model.FunctionStage]
    def eventObject: FunctionEventObject
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getIfMatch: ZIO[Any, Nothing, String] = ZIO.succeed(ifMatch)
    def getStage: ZIO[Any, AwsError, zio.aws.cloudfront.model.FunctionStage] =
      AwsError.unwrapOptionField("stage", stage)
    def getEventObject: ZIO[Any, Nothing, FunctionEventObject] =
      ZIO.succeed(eventObject)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.TestFunctionRequest
  ) extends zio.aws.cloudfront.model.TestFunctionRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val ifMatch: String = impl.ifMatch(): String
    override val stage: Option[zio.aws.cloudfront.model.FunctionStage] = scala
      .Option(impl.stage())
      .map(value => zio.aws.cloudfront.model.FunctionStage.wrap(value))
    override val eventObject: FunctionEventObject =
      zio.aws.cloudfront.model.primitives.FunctionEventObject(
        zio.Chunk.fromArray(impl.eventObject().asByteArrayUnsafe())
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.TestFunctionRequest
  ): zio.aws.cloudfront.model.TestFunctionRequest.ReadOnly = new Wrapper(impl)
}
