package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListFieldLevelEncryptionConfigsResponse(
    fieldLevelEncryptionList: Option[
      zio.aws.cloudfront.model.FieldLevelEncryptionList
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsResponse = {
    import ListFieldLevelEncryptionConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsResponse
      .builder()
      .optionallyWith(
        fieldLevelEncryptionList.map(value => value.buildAwsValue())
      )(_.fieldLevelEncryptionList)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListFieldLevelEncryptionConfigsResponse.ReadOnly =
    zio.aws.cloudfront.model.ListFieldLevelEncryptionConfigsResponse
      .wrap(buildAwsValue())
}
object ListFieldLevelEncryptionConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListFieldLevelEncryptionConfigsResponse =
      zio.aws.cloudfront.model.ListFieldLevelEncryptionConfigsResponse(
        fieldLevelEncryptionList.map(value => value.asEditable)
      )
    def fieldLevelEncryptionList
        : Option[zio.aws.cloudfront.model.FieldLevelEncryptionList.ReadOnly]
    def getFieldLevelEncryptionList: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.FieldLevelEncryptionList.ReadOnly
    ] = AwsError.unwrapOptionField(
      "fieldLevelEncryptionList",
      fieldLevelEncryptionList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsResponse
  ) extends zio.aws.cloudfront.model.ListFieldLevelEncryptionConfigsResponse.ReadOnly {
    override val fieldLevelEncryptionList
        : Option[zio.aws.cloudfront.model.FieldLevelEncryptionList.ReadOnly] =
      scala
        .Option(impl.fieldLevelEncryptionList())
        .map(value =>
          zio.aws.cloudfront.model.FieldLevelEncryptionList.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsResponse
  ): zio.aws.cloudfront.model.ListFieldLevelEncryptionConfigsResponse.ReadOnly =
    new Wrapper(impl)
}
