package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetStreamingDistributionResponse(
    streamingDistribution: Option[
      zio.aws.cloudfront.model.StreamingDistribution
    ] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse = {
    import GetStreamingDistributionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse
      .builder()
      .optionallyWith(
        streamingDistribution.map(value => value.buildAwsValue())
      )(_.streamingDistribution)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetStreamingDistributionResponse.ReadOnly =
    zio.aws.cloudfront.model.GetStreamingDistributionResponse
      .wrap(buildAwsValue())
}
object GetStreamingDistributionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetStreamingDistributionResponse =
      zio.aws.cloudfront.model.GetStreamingDistributionResponse(
        streamingDistribution.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def streamingDistribution
        : Option[zio.aws.cloudfront.model.StreamingDistribution.ReadOnly]
    def eTag: Option[String]
    def getStreamingDistribution: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.StreamingDistribution.ReadOnly
    ] =
      AwsError.unwrapOptionField("streamingDistribution", streamingDistribution)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse
  ) extends zio.aws.cloudfront.model.GetStreamingDistributionResponse.ReadOnly {
    override val streamingDistribution
        : Option[zio.aws.cloudfront.model.StreamingDistribution.ReadOnly] =
      scala
        .Option(impl.streamingDistribution())
        .map(value =>
          zio.aws.cloudfront.model.StreamingDistribution.wrap(value)
        )
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse
  ): zio.aws.cloudfront.model.GetStreamingDistributionResponse.ReadOnly =
    new Wrapper(impl)
}
