package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetInvalidationResponse(
    invalidation: Option[zio.aws.cloudfront.model.Invalidation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse = {
    import GetInvalidationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse
      .builder()
      .optionallyWith(invalidation.map(value => value.buildAwsValue()))(
        _.invalidation
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.GetInvalidationResponse.ReadOnly =
    zio.aws.cloudfront.model.GetInvalidationResponse.wrap(buildAwsValue())
}
object GetInvalidationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetInvalidationResponse =
      zio.aws.cloudfront.model
        .GetInvalidationResponse(invalidation.map(value => value.asEditable))
    def invalidation: Option[zio.aws.cloudfront.model.Invalidation.ReadOnly]
    def getInvalidation
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Invalidation.ReadOnly] =
      AwsError.unwrapOptionField("invalidation", invalidation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse
  ) extends zio.aws.cloudfront.model.GetInvalidationResponse.ReadOnly {
    override val invalidation
        : Option[zio.aws.cloudfront.model.Invalidation.ReadOnly] = scala
      .Option(impl.invalidation())
      .map(value => zio.aws.cloudfront.model.Invalidation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse
  ): zio.aws.cloudfront.model.GetInvalidationResponse.ReadOnly = new Wrapper(
    impl
  )
}
