package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetCloudFrontOriginAccessIdentityResponse(
    cloudFrontOriginAccessIdentity: Option[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity
    ] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse = {
    import GetCloudFrontOriginAccessIdentityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse
      .builder()
      .optionallyWith(
        cloudFrontOriginAccessIdentity.map(value => value.buildAwsValue())
      )(_.cloudFrontOriginAccessIdentity)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse.ReadOnly =
    zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse
      .wrap(buildAwsValue())
}
object GetCloudFrontOriginAccessIdentityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse =
      zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse(
        cloudFrontOriginAccessIdentity.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def cloudFrontOriginAccessIdentity: Option[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity.ReadOnly
    ]
    def eTag: Option[String]
    def getCloudFrontOriginAccessIdentity: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudFrontOriginAccessIdentity",
      cloudFrontOriginAccessIdentity
    )
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse
  ) extends zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse.ReadOnly {
    override val cloudFrontOriginAccessIdentity: Option[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity.ReadOnly
    ] = scala
      .Option(impl.cloudFrontOriginAccessIdentity())
      .map(value =>
        zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity.wrap(value)
      )
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse
  ): zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse.ReadOnly =
    new Wrapper(impl)
}
