package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class EncryptionEntities(
    quantity: Integer,
    items: Option[Iterable[zio.aws.cloudfront.model.EncryptionEntity]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.EncryptionEntities = {
    import EncryptionEntities.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.EncryptionEntities
      .builder()
      .quantity(Integer.unwrap(quantity): java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.EncryptionEntities.ReadOnly =
    zio.aws.cloudfront.model.EncryptionEntities.wrap(buildAwsValue())
}
object EncryptionEntities {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.EncryptionEntities
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.EncryptionEntities =
      zio.aws.cloudfront.model.EncryptionEntities(
        quantity,
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def quantity: Integer
    def items: Option[List[zio.aws.cloudfront.model.EncryptionEntity.ReadOnly]]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.EncryptionEntity.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.EncryptionEntities
  ) extends zio.aws.cloudfront.model.EncryptionEntities.ReadOnly {
    override val quantity: Integer =
      zio.aws.cloudfront.model.primitives.Integer(impl.quantity())
    override val items
        : Option[List[zio.aws.cloudfront.model.EncryptionEntity.ReadOnly]] =
      scala
        .Option(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudfront.model.EncryptionEntity.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.EncryptionEntities
  ): zio.aws.cloudfront.model.EncryptionEntities.ReadOnly = new Wrapper(impl)
}
