package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeFunctionResponse(
    functionSummary: Option[zio.aws.cloudfront.model.FunctionSummary] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DescribeFunctionResponse = {
    import DescribeFunctionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DescribeFunctionResponse
      .builder()
      .optionallyWith(functionSummary.map(value => value.buildAwsValue()))(
        _.functionSummary
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DescribeFunctionResponse.ReadOnly =
    zio.aws.cloudfront.model.DescribeFunctionResponse.wrap(buildAwsValue())
}
object DescribeFunctionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DescribeFunctionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DescribeFunctionResponse =
      zio.aws.cloudfront.model.DescribeFunctionResponse(
        functionSummary.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def functionSummary
        : Option[zio.aws.cloudfront.model.FunctionSummary.ReadOnly]
    def eTag: Option[String]
    def getFunctionSummary: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.FunctionSummary.ReadOnly
    ] = AwsError.unwrapOptionField("functionSummary", functionSummary)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DescribeFunctionResponse
  ) extends zio.aws.cloudfront.model.DescribeFunctionResponse.ReadOnly {
    override val functionSummary
        : Option[zio.aws.cloudfront.model.FunctionSummary.ReadOnly] = scala
      .Option(impl.functionSummary())
      .map(value => zio.aws.cloudfront.model.FunctionSummary.wrap(value))
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DescribeFunctionResponse
  ): zio.aws.cloudfront.model.DescribeFunctionResponse.ReadOnly = new Wrapper(
    impl
  )
}
