package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteFieldLevelEncryptionConfigRequest(
    id: String,
    ifMatch: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest = {
    import DeleteFieldLevelEncryptionConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest.ReadOnly =
    zio.aws.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest
      .wrap(buildAwsValue())
}
object DeleteFieldLevelEncryptionConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest =
      zio.aws.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest(
        id,
        ifMatch.map(value => value)
      )
    def id: String
    def ifMatch: Option[String]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest
  ) extends zio.aws.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest.ReadOnly {
    override val id: String = impl.id(): String
    override val ifMatch: Option[String] =
      scala.Option(impl.ifMatch()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest
  ): zio.aws.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest.ReadOnly =
    new Wrapper(impl)
}
