package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class CachedMethods(
    quantity: Integer,
    items: Iterable[zio.aws.cloudfront.model.Method]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CachedMethods = {
    import CachedMethods.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CachedMethods
      .builder()
      .quantity(Integer.unwrap(quantity): java.lang.Integer)
      .itemsWithStrings(items.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CachedMethods.ReadOnly =
    zio.aws.cloudfront.model.CachedMethods.wrap(buildAwsValue())
}
object CachedMethods {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CachedMethods
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CachedMethods =
      zio.aws.cloudfront.model.CachedMethods(quantity, items)
    def quantity: Integer
    def items: List[zio.aws.cloudfront.model.Method]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, Nothing, List[zio.aws.cloudfront.model.Method]] =
      ZIO.succeed(items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CachedMethods
  ) extends zio.aws.cloudfront.model.CachedMethods.ReadOnly {
    override val quantity: Integer =
      zio.aws.cloudfront.model.primitives.Integer(impl.quantity())
    override val items: List[zio.aws.cloudfront.model.Method] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.cloudfront.model.Method.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CachedMethods
  ): zio.aws.cloudfront.model.CachedMethods.ReadOnly = new Wrapper(impl)
}
