package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateFieldLevelEncryptionProfileRequest(
    fieldLevelEncryptionProfileConfig: zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig,
    id: String,
    ifMatch: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest = {
    import UpdateFieldLevelEncryptionProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest
      .builder()
      .fieldLevelEncryptionProfileConfig(
        fieldLevelEncryptionProfileConfig.buildAwsValue()
      )
      .id(id: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest
      .wrap(buildAwsValue())
}
object UpdateFieldLevelEncryptionProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest =
      zio.aws.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest(
        fieldLevelEncryptionProfileConfig.asEditable,
        id,
        ifMatch.map(value => value)
      )
    def fieldLevelEncryptionProfileConfig
        : zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig.ReadOnly
    def id: String
    def ifMatch: Option[String]
    def getFieldLevelEncryptionProfileConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig.ReadOnly
    ] = ZIO.succeed(fieldLevelEncryptionProfileConfig)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest
  ) extends zio.aws.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest.ReadOnly {
    override val fieldLevelEncryptionProfileConfig
        : zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig.ReadOnly =
      zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig
        .wrap(impl.fieldLevelEncryptionProfileConfig())
    override val id: String = impl.id(): String
    override val ifMatch: Option[String] =
      scala.Option(impl.ifMatch()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest
  ): zio.aws.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest.ReadOnly =
    new Wrapper(impl)
}
