package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListCloudFrontOriginAccessIdentitiesResponse(
    cloudFrontOriginAccessIdentityList: Option[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityList
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse = {
    import ListCloudFrontOriginAccessIdentitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse
      .builder()
      .optionallyWith(
        cloudFrontOriginAccessIdentityList.map(value => value.buildAwsValue())
      )(_.cloudFrontOriginAccessIdentityList)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse.ReadOnly =
    zio.aws.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse
      .wrap(buildAwsValue())
}
object ListCloudFrontOriginAccessIdentitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse =
      zio.aws.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse(
        cloudFrontOriginAccessIdentityList.map(value => value.asEditable)
      )
    def cloudFrontOriginAccessIdentityList: Option[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityList.ReadOnly
    ]
    def getCloudFrontOriginAccessIdentityList: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityList.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudFrontOriginAccessIdentityList",
      cloudFrontOriginAccessIdentityList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse
  ) extends zio.aws.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse.ReadOnly {
    override val cloudFrontOriginAccessIdentityList: Option[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityList.ReadOnly
    ] = scala
      .Option(impl.cloudFrontOriginAccessIdentityList())
      .map(value =>
        zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityList.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse
  ): zio.aws.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse.ReadOnly =
    new Wrapper(impl)
}
