package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreatePublicKeyRequest(
    publicKeyConfig: zio.aws.cloudfront.model.PublicKeyConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyRequest = {
    import CreatePublicKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyRequest
      .builder()
      .publicKeyConfig(publicKeyConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CreatePublicKeyRequest.ReadOnly =
    zio.aws.cloudfront.model.CreatePublicKeyRequest.wrap(buildAwsValue())
}
object CreatePublicKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreatePublicKeyRequest =
      zio.aws.cloudfront.model
        .CreatePublicKeyRequest(publicKeyConfig.asEditable)
    def publicKeyConfig: zio.aws.cloudfront.model.PublicKeyConfig.ReadOnly
    def getPublicKeyConfig
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.PublicKeyConfig.ReadOnly] =
      ZIO.succeed(publicKeyConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyRequest
  ) extends zio.aws.cloudfront.model.CreatePublicKeyRequest.ReadOnly {
    override val publicKeyConfig
        : zio.aws.cloudfront.model.PublicKeyConfig.ReadOnly =
      zio.aws.cloudfront.model.PublicKeyConfig.wrap(impl.publicKeyConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyRequest
  ): zio.aws.cloudfront.model.CreatePublicKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
