package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateCloudFrontOriginAccessIdentityRequest(
    cloudFrontOriginAccessIdentityConfig: zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig,
    id: String,
    ifMatch: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest = {
    import UpdateCloudFrontOriginAccessIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest
      .builder()
      .cloudFrontOriginAccessIdentityConfig(
        cloudFrontOriginAccessIdentityConfig.buildAwsValue()
      )
      .id(id: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest
      .wrap(buildAwsValue())
}
object UpdateCloudFrontOriginAccessIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest =
      zio.aws.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest(
        cloudFrontOriginAccessIdentityConfig.asEditable,
        id,
        ifMatch.map(value => value)
      )
    def cloudFrontOriginAccessIdentityConfig
        : zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig.ReadOnly
    def id: String
    def ifMatch: Option[String]
    def getCloudFrontOriginAccessIdentityConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig.ReadOnly
    ] = ZIO.succeed(cloudFrontOriginAccessIdentityConfig)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest
  ) extends zio.aws.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest.ReadOnly {
    override val cloudFrontOriginAccessIdentityConfig
        : zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig.ReadOnly =
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig
        .wrap(impl.cloudFrontOriginAccessIdentityConfig())
    override val id: String = impl.id(): String
    override val ifMatch: Option[String] =
      scala.Option(impl.ifMatch()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest
  ): zio.aws.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest.ReadOnly =
    new Wrapper(impl)
}
