package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class TrustedKeyGroups(
    enabled: Boolean,
    quantity: Integer,
    items: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.TrustedKeyGroups = {
    import TrustedKeyGroups.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.TrustedKeyGroups
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .quantity(Integer.unwrap(quantity): java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.TrustedKeyGroups.ReadOnly =
    zio.aws.cloudfront.model.TrustedKeyGroups.wrap(buildAwsValue())
}
object TrustedKeyGroups {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.TrustedKeyGroups
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.TrustedKeyGroups =
      zio.aws.cloudfront.model
        .TrustedKeyGroups(enabled, quantity, items.map(value => value))
    def enabled: Boolean
    def quantity: Integer
    def items: Option[List[String]]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.TrustedKeyGroups
  ) extends zio.aws.cloudfront.model.TrustedKeyGroups.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val quantity: Integer =
      zio.aws.cloudfront.model.primitives.Integer(impl.quantity())
    override val items: Option[List[String]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.TrustedKeyGroups
  ): zio.aws.cloudfront.model.TrustedKeyGroups.ReadOnly = new Wrapper(impl)
}
