package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDistributionsRequest(
    marker: Option[String] = None,
    maxItems: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest = {
    import ListDistributionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.String))(
        _.maxItems
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ListDistributionsRequest.ReadOnly =
    zio.aws.cloudfront.model.ListDistributionsRequest.wrap(buildAwsValue())
}
object ListDistributionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListDistributionsRequest =
      zio.aws.cloudfront.model.ListDistributionsRequest(
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def marker: Option[String]
    def maxItems: Option[String]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest
  ) extends zio.aws.cloudfront.model.ListDistributionsRequest.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxItems: Option[String] =
      scala.Option(impl.maxItems()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest
  ): zio.aws.cloudfront.model.ListDistributionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
