package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateRealtimeLogConfigResponse(
    realtimeLogConfig: Option[zio.aws.cloudfront.model.RealtimeLogConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigResponse = {
    import UpdateRealtimeLogConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigResponse
      .builder()
      .optionallyWith(realtimeLogConfig.map(value => value.buildAwsValue()))(
        _.realtimeLogConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateRealtimeLogConfigResponse.ReadOnly =
    zio.aws.cloudfront.model.UpdateRealtimeLogConfigResponse
      .wrap(buildAwsValue())
}
object UpdateRealtimeLogConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateRealtimeLogConfigResponse =
      zio.aws.cloudfront.model.UpdateRealtimeLogConfigResponse(
        realtimeLogConfig.map(value => value.asEditable)
      )
    def realtimeLogConfig
        : Option[zio.aws.cloudfront.model.RealtimeLogConfig.ReadOnly]
    def getRealtimeLogConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.RealtimeLogConfig.ReadOnly
    ] = AwsError.unwrapOptionField("realtimeLogConfig", realtimeLogConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigResponse
  ) extends zio.aws.cloudfront.model.UpdateRealtimeLogConfigResponse.ReadOnly {
    override val realtimeLogConfig
        : Option[zio.aws.cloudfront.model.RealtimeLogConfig.ReadOnly] = scala
      .Option(impl.realtimeLogConfig())
      .map(value => zio.aws.cloudfront.model.RealtimeLogConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigResponse
  ): zio.aws.cloudfront.model.UpdateRealtimeLogConfigResponse.ReadOnly =
    new Wrapper(impl)
}
