package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TestFunctionResponse(
    testResult: Option[zio.aws.cloudfront.model.TestResult] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.TestFunctionResponse = {
    import TestFunctionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.TestFunctionResponse
      .builder()
      .optionallyWith(testResult.map(value => value.buildAwsValue()))(
        _.testResult
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.TestFunctionResponse.ReadOnly =
    zio.aws.cloudfront.model.TestFunctionResponse.wrap(buildAwsValue())
}
object TestFunctionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.TestFunctionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.TestFunctionResponse =
      zio.aws.cloudfront.model
        .TestFunctionResponse(testResult.map(value => value.asEditable))
    def testResult: Option[zio.aws.cloudfront.model.TestResult.ReadOnly]
    def getTestResult
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.TestResult.ReadOnly] =
      AwsError.unwrapOptionField("testResult", testResult)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.TestFunctionResponse
  ) extends zio.aws.cloudfront.model.TestFunctionResponse.ReadOnly {
    override val testResult
        : Option[zio.aws.cloudfront.model.TestResult.ReadOnly] = scala
      .Option(impl.testResult())
      .map(value => zio.aws.cloudfront.model.TestResult.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.TestFunctionResponse
  ): zio.aws.cloudfront.model.TestFunctionResponse.ReadOnly = new Wrapper(impl)
}
