package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListResponseHeadersPoliciesResponse(
    responseHeadersPolicyList: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyList
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListResponseHeadersPoliciesResponse = {
    import ListResponseHeadersPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListResponseHeadersPoliciesResponse
      .builder()
      .optionallyWith(
        responseHeadersPolicyList.map(value => value.buildAwsValue())
      )(_.responseHeadersPolicyList)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListResponseHeadersPoliciesResponse.ReadOnly =
    zio.aws.cloudfront.model.ListResponseHeadersPoliciesResponse
      .wrap(buildAwsValue())
}
object ListResponseHeadersPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListResponseHeadersPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListResponseHeadersPoliciesResponse =
      zio.aws.cloudfront.model.ListResponseHeadersPoliciesResponse(
        responseHeadersPolicyList.map(value => value.asEditable)
      )
    def responseHeadersPolicyList
        : Option[zio.aws.cloudfront.model.ResponseHeadersPolicyList.ReadOnly]
    def getResponseHeadersPolicyList: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicyList.ReadOnly
    ] = AwsError.unwrapOptionField(
      "responseHeadersPolicyList",
      responseHeadersPolicyList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListResponseHeadersPoliciesResponse
  ) extends zio.aws.cloudfront.model.ListResponseHeadersPoliciesResponse.ReadOnly {
    override val responseHeadersPolicyList
        : Option[zio.aws.cloudfront.model.ResponseHeadersPolicyList.ReadOnly] =
      scala
        .Option(impl.responseHeadersPolicyList())
        .map(value =>
          zio.aws.cloudfront.model.ResponseHeadersPolicyList.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListResponseHeadersPoliciesResponse
  ): zio.aws.cloudfront.model.ListResponseHeadersPoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
