package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDistributionsResponse(
    distributionList: Option[zio.aws.cloudfront.model.DistributionList] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse = {
    import ListDistributionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse
      .builder()
      .optionallyWith(distributionList.map(value => value.buildAwsValue()))(
        _.distributionList
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ListDistributionsResponse.ReadOnly =
    zio.aws.cloudfront.model.ListDistributionsResponse.wrap(buildAwsValue())
}
object ListDistributionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListDistributionsResponse =
      zio.aws.cloudfront.model.ListDistributionsResponse(
        distributionList.map(value => value.asEditable)
      )
    def distributionList
        : Option[zio.aws.cloudfront.model.DistributionList.ReadOnly]
    def getDistributionList: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.DistributionList.ReadOnly
    ] = AwsError.unwrapOptionField("distributionList", distributionList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse
  ) extends zio.aws.cloudfront.model.ListDistributionsResponse.ReadOnly {
    override val distributionList
        : Option[zio.aws.cloudfront.model.DistributionList.ReadOnly] = scala
      .Option(impl.distributionList())
      .map(value => zio.aws.cloudfront.model.DistributionList.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse
  ): zio.aws.cloudfront.model.ListDistributionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
