package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListRealtimeLogConfigsRequest(
    maxItems: Option[String] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsRequest = {
    import ListRealtimeLogConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsRequest
      .builder()
      .optionallyWith(maxItems.map(value => value: java.lang.String))(
        _.maxItems
      )
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListRealtimeLogConfigsRequest.ReadOnly =
    zio.aws.cloudfront.model.ListRealtimeLogConfigsRequest.wrap(buildAwsValue())
}
object ListRealtimeLogConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListRealtimeLogConfigsRequest =
      zio.aws.cloudfront.model.ListRealtimeLogConfigsRequest(
        maxItems.map(value => value),
        marker.map(value => value)
      )
    def maxItems: Option[String]
    def marker: Option[String]
    def getMaxItems: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsRequest
  ) extends zio.aws.cloudfront.model.ListRealtimeLogConfigsRequest.ReadOnly {
    override val maxItems: Option[String] =
      scala.Option(impl.maxItems()).map(value => value: String)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsRequest
  ): zio.aws.cloudfront.model.ListRealtimeLogConfigsRequest.ReadOnly =
    new Wrapper(impl)
}
