package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class CacheBehaviors(
    quantity: Integer,
    items: Option[Iterable[zio.aws.cloudfront.model.CacheBehavior]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CacheBehaviors = {
    import CacheBehaviors.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CacheBehaviors
      .builder()
      .quantity(Integer.unwrap(quantity): java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CacheBehaviors.ReadOnly =
    zio.aws.cloudfront.model.CacheBehaviors.wrap(buildAwsValue())
}
object CacheBehaviors {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CacheBehaviors
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CacheBehaviors =
      zio.aws.cloudfront.model.CacheBehaviors(
        quantity,
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def quantity: Integer
    def items: Option[List[zio.aws.cloudfront.model.CacheBehavior.ReadOnly]]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.CacheBehavior.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CacheBehaviors
  ) extends zio.aws.cloudfront.model.CacheBehaviors.ReadOnly {
    override val quantity: Integer =
      zio.aws.cloudfront.model.primitives.Integer(impl.quantity())
    override val items
        : Option[List[zio.aws.cloudfront.model.CacheBehavior.ReadOnly]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudfront.model.CacheBehavior.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CacheBehaviors
  ): zio.aws.cloudfront.model.CacheBehaviors.ReadOnly = new Wrapper(impl)
}
