package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ViewerCertificate(
    cloudFrontDefaultCertificate: Option[Boolean] = None,
    iamCertificateId: Option[String] = None,
    acmCertificateArn: Option[String] = None,
    sslSupportMethod: Option[zio.aws.cloudfront.model.SSLSupportMethod] = None,
    minimumProtocolVersion: Option[
      zio.aws.cloudfront.model.MinimumProtocolVersion
    ] = None,
    certificate: Option[String] = None,
    certificateSource: Option[zio.aws.cloudfront.model.CertificateSource] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ViewerCertificate = {
    import ViewerCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ViewerCertificate
      .builder()
      .optionallyWith(
        cloudFrontDefaultCertificate.map(value => value: java.lang.Boolean)
      )(_.cloudFrontDefaultCertificate)
      .optionallyWith(iamCertificateId.map(value => value: java.lang.String))(
        _.iamCertificateId
      )
      .optionallyWith(acmCertificateArn.map(value => value: java.lang.String))(
        _.acmCertificateArn
      )
      .optionallyWith(sslSupportMethod.map(value => value.unwrap))(
        _.sslSupportMethod
      )
      .optionallyWith(minimumProtocolVersion.map(value => value.unwrap))(
        _.minimumProtocolVersion
      )
      .optionallyWith(certificate.map(value => value: java.lang.String))(
        _.certificate
      )
      .optionallyWith(certificateSource.map(value => value.unwrap))(
        _.certificateSource
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ViewerCertificate.ReadOnly =
    zio.aws.cloudfront.model.ViewerCertificate.wrap(buildAwsValue())
}
object ViewerCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ViewerCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ViewerCertificate =
      zio.aws.cloudfront.model.ViewerCertificate(
        cloudFrontDefaultCertificate.map(value => value),
        iamCertificateId.map(value => value),
        acmCertificateArn.map(value => value),
        sslSupportMethod.map(value => value),
        minimumProtocolVersion.map(value => value),
        certificate.map(value => value),
        certificateSource.map(value => value)
      )
    def cloudFrontDefaultCertificate: Option[Boolean]
    def iamCertificateId: Option[String]
    def acmCertificateArn: Option[String]
    def sslSupportMethod: Option[zio.aws.cloudfront.model.SSLSupportMethod]
    def minimumProtocolVersion
        : Option[zio.aws.cloudfront.model.MinimumProtocolVersion]
    def certificate: Option[String]
    def certificateSource: Option[zio.aws.cloudfront.model.CertificateSource]
    def getCloudFrontDefaultCertificate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "cloudFrontDefaultCertificate",
        cloudFrontDefaultCertificate
      )
    def getIamCertificateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("iamCertificateId", iamCertificateId)
    def getAcmCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("acmCertificateArn", acmCertificateArn)
    def getSslSupportMethod
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.SSLSupportMethod] =
      AwsError.unwrapOptionField("sslSupportMethod", sslSupportMethod)
    def getMinimumProtocolVersion
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.MinimumProtocolVersion] =
      AwsError.unwrapOptionField(
        "minimumProtocolVersion",
        minimumProtocolVersion
      )
    def getCertificate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getCertificateSource
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.CertificateSource] =
      AwsError.unwrapOptionField("certificateSource", certificateSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ViewerCertificate
  ) extends zio.aws.cloudfront.model.ViewerCertificate.ReadOnly {
    override val cloudFrontDefaultCertificate: Option[Boolean] = scala
      .Option(impl.cloudFrontDefaultCertificate())
      .map(value => value: Boolean)
    override val iamCertificateId: Option[String] =
      scala.Option(impl.iamCertificateId()).map(value => value: String)
    override val acmCertificateArn: Option[String] =
      scala.Option(impl.acmCertificateArn()).map(value => value: String)
    override val sslSupportMethod
        : Option[zio.aws.cloudfront.model.SSLSupportMethod] = scala
      .Option(impl.sslSupportMethod())
      .map(value => zio.aws.cloudfront.model.SSLSupportMethod.wrap(value))
    override val minimumProtocolVersion
        : Option[zio.aws.cloudfront.model.MinimumProtocolVersion] = scala
      .Option(impl.minimumProtocolVersion())
      .map(value => zio.aws.cloudfront.model.MinimumProtocolVersion.wrap(value))
    override val certificate: Option[String] =
      scala.Option(impl.certificate()).map(value => value: String)
    override val certificateSource
        : Option[zio.aws.cloudfront.model.CertificateSource] = scala
      .Option(impl.certificateSource())
      .map(value => zio.aws.cloudfront.model.CertificateSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ViewerCertificate
  ): zio.aws.cloudfront.model.ViewerCertificate.ReadOnly = new Wrapper(impl)
}
