package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateRealtimeLogConfigRequest(
    endPoints: Option[Iterable[zio.aws.cloudfront.model.EndPoint]] = None,
    fields: Option[Iterable[String]] = None,
    name: Option[String] = None,
    arn: Option[String] = None,
    samplingRate: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigRequest = {
    import UpdateRealtimeLogConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigRequest
      .builder()
      .optionallyWith(
        endPoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endPoints)
      .optionallyWith(
        fields.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.fields)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(samplingRate.map(value => value: java.lang.Long))(
        _.samplingRate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateRealtimeLogConfigRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdateRealtimeLogConfigRequest
      .wrap(buildAwsValue())
}
object UpdateRealtimeLogConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateRealtimeLogConfigRequest =
      zio.aws.cloudfront.model.UpdateRealtimeLogConfigRequest(
        endPoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        fields.map(value => value),
        name.map(value => value),
        arn.map(value => value),
        samplingRate.map(value => value)
      )
    def endPoints: Option[List[zio.aws.cloudfront.model.EndPoint.ReadOnly]]
    def fields: Option[List[String]]
    def name: Option[String]
    def arn: Option[String]
    def samplingRate: Option[Long]
    def getEndPoints
        : ZIO[Any, AwsError, List[zio.aws.cloudfront.model.EndPoint.ReadOnly]] =
      AwsError.unwrapOptionField("endPoints", endPoints)
    def getFields: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("fields", fields)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getSamplingRate: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("samplingRate", samplingRate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigRequest
  ) extends zio.aws.cloudfront.model.UpdateRealtimeLogConfigRequest.ReadOnly {
    override val endPoints
        : Option[List[zio.aws.cloudfront.model.EndPoint.ReadOnly]] = scala
      .Option(impl.endPoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudfront.model.EndPoint.wrap(item)
        }.toList
      )
    override val fields: Option[List[String]] = scala
      .Option(impl.fields())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val samplingRate: Option[Long] =
      scala.Option(impl.samplingRate()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigRequest
  ): zio.aws.cloudfront.model.UpdateRealtimeLogConfigRequest.ReadOnly =
    new Wrapper(impl)
}
