package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateCachePolicyResponse(
    cachePolicy: Option[zio.aws.cloudfront.model.CachePolicy] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyResponse = {
    import UpdateCachePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyResponse
      .builder()
      .optionallyWith(cachePolicy.map(value => value.buildAwsValue()))(
        _.cachePolicy
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.UpdateCachePolicyResponse.ReadOnly =
    zio.aws.cloudfront.model.UpdateCachePolicyResponse.wrap(buildAwsValue())
}
object UpdateCachePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateCachePolicyResponse =
      zio.aws.cloudfront.model.UpdateCachePolicyResponse(
        cachePolicy.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def cachePolicy: Option[zio.aws.cloudfront.model.CachePolicy.ReadOnly]
    def eTag: Option[String]
    def getCachePolicy
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.CachePolicy.ReadOnly] =
      AwsError.unwrapOptionField("cachePolicy", cachePolicy)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyResponse
  ) extends zio.aws.cloudfront.model.UpdateCachePolicyResponse.ReadOnly {
    override val cachePolicy
        : Option[zio.aws.cloudfront.model.CachePolicy.ReadOnly] = scala
      .Option(impl.cachePolicy())
      .map(value => zio.aws.cloudfront.model.CachePolicy.wrap(value))
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyResponse
  ): zio.aws.cloudfront.model.UpdateCachePolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
