package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.TagKey
import scala.jdk.CollectionConverters._
final case class TagKeys(items: Option[Iterable[TagKey]] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.TagKeys = {
    import TagKeys.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.TagKeys
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            TagKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.TagKeys.ReadOnly =
    zio.aws.cloudfront.model.TagKeys.wrap(buildAwsValue())
}
object TagKeys {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.TagKeys
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.TagKeys =
      zio.aws.cloudfront.model.TagKeys(items.map(value => value))
    def items: Option[List[TagKey]]
    def getItems: ZIO[Any, AwsError, List[TagKey]] =
      AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.TagKeys
  ) extends zio.aws.cloudfront.model.TagKeys.ReadOnly {
    override val items: Option[List[TagKey]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudfront.model.primitives.TagKey(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.TagKeys
  ): zio.aws.cloudfront.model.TagKeys.ReadOnly = new Wrapper(impl)
}
