package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class OriginRequestPolicy(
    id: String,
    lastModifiedTime: Timestamp,
    originRequestPolicyConfig: zio.aws.cloudfront.model.OriginRequestPolicyConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicy = {
    import OriginRequestPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicy
      .builder()
      .id(id: java.lang.String)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .originRequestPolicyConfig(originRequestPolicyConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly =
    zio.aws.cloudfront.model.OriginRequestPolicy.wrap(buildAwsValue())
}
object OriginRequestPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.OriginRequestPolicy =
      zio.aws.cloudfront.model.OriginRequestPolicy(
        id,
        lastModifiedTime,
        originRequestPolicyConfig.asEditable
      )
    def id: String
    def lastModifiedTime: Timestamp
    def originRequestPolicyConfig
        : zio.aws.cloudfront.model.OriginRequestPolicyConfig.ReadOnly
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getOriginRequestPolicyConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginRequestPolicyConfig.ReadOnly
    ] = ZIO.succeed(originRequestPolicyConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicy
  ) extends zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly {
    override val id: String = impl.id(): String
    override val lastModifiedTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.lastModifiedTime())
    override val originRequestPolicyConfig
        : zio.aws.cloudfront.model.OriginRequestPolicyConfig.ReadOnly =
      zio.aws.cloudfront.model.OriginRequestPolicyConfig
        .wrap(impl.originRequestPolicyConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicy
  ): zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly = new Wrapper(impl)
}
