package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetResponseHeadersPolicyConfigResponse(
    responseHeadersPolicyConfig: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyConfig
    ] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyConfigResponse = {
    import GetResponseHeadersPolicyConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyConfigResponse
      .builder()
      .optionallyWith(
        responseHeadersPolicyConfig.map(value => value.buildAwsValue())
      )(_.responseHeadersPolicyConfig)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetResponseHeadersPolicyConfigResponse.ReadOnly =
    zio.aws.cloudfront.model.GetResponseHeadersPolicyConfigResponse
      .wrap(buildAwsValue())
}
object GetResponseHeadersPolicyConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.GetResponseHeadersPolicyConfigResponse =
      zio.aws.cloudfront.model.GetResponseHeadersPolicyConfigResponse(
        responseHeadersPolicyConfig.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def responseHeadersPolicyConfig
        : Option[zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.ReadOnly]
    def eTag: Option[String]
    def getResponseHeadersPolicyConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "responseHeadersPolicyConfig",
      responseHeadersPolicyConfig
    )
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyConfigResponse
  ) extends zio.aws.cloudfront.model.GetResponseHeadersPolicyConfigResponse.ReadOnly {
    override val responseHeadersPolicyConfig: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.ReadOnly
    ] = scala
      .Option(impl.responseHeadersPolicyConfig())
      .map(value =>
        zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.wrap(value)
      )
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyConfigResponse
  ): zio.aws.cloudfront.model.GetResponseHeadersPolicyConfigResponse.ReadOnly =
    new Wrapper(impl)
}
