package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetOriginRequestPolicyResponse(
    originRequestPolicy: Option[zio.aws.cloudfront.model.OriginRequestPolicy] =
      None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyResponse = {
    import GetOriginRequestPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyResponse
      .builder()
      .optionallyWith(originRequestPolicy.map(value => value.buildAwsValue()))(
        _.originRequestPolicy
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetOriginRequestPolicyResponse.ReadOnly =
    zio.aws.cloudfront.model.GetOriginRequestPolicyResponse
      .wrap(buildAwsValue())
}
object GetOriginRequestPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetOriginRequestPolicyResponse =
      zio.aws.cloudfront.model.GetOriginRequestPolicyResponse(
        originRequestPolicy.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def originRequestPolicy
        : Option[zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly]
    def eTag: Option[String]
    def getOriginRequestPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("originRequestPolicy", originRequestPolicy)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyResponse
  ) extends zio.aws.cloudfront.model.GetOriginRequestPolicyResponse.ReadOnly {
    override val originRequestPolicy
        : Option[zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly] = scala
      .Option(impl.originRequestPolicy())
      .map(value => zio.aws.cloudfront.model.OriginRequestPolicy.wrap(value))
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyResponse
  ): zio.aws.cloudfront.model.GetOriginRequestPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
