package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteKeyGroupRequest(
    id: String,
    ifMatch: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DeleteKeyGroupRequest = {
    import DeleteKeyGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DeleteKeyGroupRequest
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DeleteKeyGroupRequest.ReadOnly =
    zio.aws.cloudfront.model.DeleteKeyGroupRequest.wrap(buildAwsValue())
}
object DeleteKeyGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DeleteKeyGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DeleteKeyGroupRequest =
      zio.aws.cloudfront.model
        .DeleteKeyGroupRequest(id, ifMatch.map(value => value))
    def id: String
    def ifMatch: Option[String]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteKeyGroupRequest
  ) extends zio.aws.cloudfront.model.DeleteKeyGroupRequest.ReadOnly {
    override val id: String = impl.id(): String
    override val ifMatch: Option[String] =
      scala.Option(impl.ifMatch()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteKeyGroupRequest
  ): zio.aws.cloudfront.model.DeleteKeyGroupRequest.ReadOnly = new Wrapper(impl)
}
