package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class ConflictingAliasesList(
    nextMarker: Option[String] = None,
    maxItems: Option[Integer] = None,
    quantity: Option[Integer] = None,
    items: Option[Iterable[zio.aws.cloudfront.model.ConflictingAlias]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ConflictingAliasesList = {
    import ConflictingAliasesList.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ConflictingAliasesList
      .builder()
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .optionallyWith(
        maxItems.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxItems)
      .optionallyWith(
        quantity.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.quantity)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ConflictingAliasesList.ReadOnly =
    zio.aws.cloudfront.model.ConflictingAliasesList.wrap(buildAwsValue())
}
object ConflictingAliasesList {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ConflictingAliasesList
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ConflictingAliasesList =
      zio.aws.cloudfront.model.ConflictingAliasesList(
        nextMarker.map(value => value),
        maxItems.map(value => value),
        quantity.map(value => value),
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[String]
    def maxItems: Option[Integer]
    def quantity: Option[Integer]
    def items: Option[List[zio.aws.cloudfront.model.ConflictingAlias.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getMaxItems: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getQuantity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("quantity", quantity)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.ConflictingAlias.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ConflictingAliasesList
  ) extends zio.aws.cloudfront.model.ConflictingAliasesList.ReadOnly {
    override val nextMarker: Option[String] =
      scala.Option(impl.nextMarker()).map(value => value: String)
    override val maxItems: Option[Integer] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.cloudfront.model.primitives.Integer(value))
    override val quantity: Option[Integer] = scala
      .Option(impl.quantity())
      .map(value => zio.aws.cloudfront.model.primitives.Integer(value))
    override val items
        : Option[List[zio.aws.cloudfront.model.ConflictingAlias.ReadOnly]] =
      scala
        .Option(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudfront.model.ConflictingAlias.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ConflictingAliasesList
  ): zio.aws.cloudfront.model.ConflictingAliasesList.ReadOnly = new Wrapper(
    impl
  )
}
