package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ConflictingAlias(
    alias: Option[String] = None,
    distributionId: Option[String] = None,
    accountId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ConflictingAlias = {
    import ConflictingAlias.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ConflictingAlias
      .builder()
      .optionallyWith(alias.map(value => value: java.lang.String))(_.alias)
      .optionallyWith(distributionId.map(value => value: java.lang.String))(
        _.distributionId
      )
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ConflictingAlias.ReadOnly =
    zio.aws.cloudfront.model.ConflictingAlias.wrap(buildAwsValue())
}
object ConflictingAlias {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ConflictingAlias
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ConflictingAlias =
      zio.aws.cloudfront.model.ConflictingAlias(
        alias.map(value => value),
        distributionId.map(value => value),
        accountId.map(value => value)
      )
    def alias: Option[String]
    def distributionId: Option[String]
    def accountId: Option[String]
    def getAlias: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("alias", alias)
    def getDistributionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("distributionId", distributionId)
    def getAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ConflictingAlias
  ) extends zio.aws.cloudfront.model.ConflictingAlias.ReadOnly {
    override val alias: Option[String] =
      scala.Option(impl.alias()).map(value => value: String)
    override val distributionId: Option[String] =
      scala.Option(impl.distributionId()).map(value => value: String)
    override val accountId: Option[String] =
      scala.Option(impl.accountId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ConflictingAlias
  ): zio.aws.cloudfront.model.ConflictingAlias.ReadOnly = new Wrapper(impl)
}
