package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AliasICPRecordal(
    cname: Option[String] = None,
    icpRecordalStatus: Option[zio.aws.cloudfront.model.ICPRecordalStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.AliasICPRecordal = {
    import AliasICPRecordal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.AliasICPRecordal
      .builder()
      .optionallyWith(cname.map(value => value: java.lang.String))(_.cname)
      .optionallyWith(icpRecordalStatus.map(value => value.unwrap))(
        _.icpRecordalStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.AliasICPRecordal.ReadOnly =
    zio.aws.cloudfront.model.AliasICPRecordal.wrap(buildAwsValue())
}
object AliasICPRecordal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.AliasICPRecordal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.AliasICPRecordal =
      zio.aws.cloudfront.model.AliasICPRecordal(
        cname.map(value => value),
        icpRecordalStatus.map(value => value)
      )
    def cname: Option[String]
    def icpRecordalStatus: Option[zio.aws.cloudfront.model.ICPRecordalStatus]
    def getCname: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cname", cname)
    def getIcpRecordalStatus
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.ICPRecordalStatus] =
      AwsError.unwrapOptionField("icpRecordalStatus", icpRecordalStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.AliasICPRecordal
  ) extends zio.aws.cloudfront.model.AliasICPRecordal.ReadOnly {
    override val cname: Option[String] =
      scala.Option(impl.cname()).map(value => value: String)
    override val icpRecordalStatus
        : Option[zio.aws.cloudfront.model.ICPRecordalStatus] = scala
      .Option(impl.icpRecordalStatus())
      .map(value => zio.aws.cloudfront.model.ICPRecordalStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.AliasICPRecordal
  ): zio.aws.cloudfront.model.AliasICPRecordal.ReadOnly = new Wrapper(impl)
}
