package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListFieldLevelEncryptionProfilesRequest(
    marker: Option[String] = None,
    maxItems: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest = {
    import ListFieldLevelEncryptionProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.String))(
        _.maxItems
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesRequest.ReadOnly =
    zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesRequest
      .wrap(buildAwsValue())
}
object ListFieldLevelEncryptionProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesRequest =
      zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesRequest(
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def marker: Option[String]
    def maxItems: Option[String]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest
  ) extends zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesRequest.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxItems: Option[String] =
      scala.Option(impl.maxItems()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest
  ): zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesRequest.ReadOnly =
    new Wrapper(impl)
}
