package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FieldLevelEncryptionConfig(
    callerReference: String,
    comment: Option[String] = None,
    queryArgProfileConfig: Option[
      zio.aws.cloudfront.model.QueryArgProfileConfig
    ] = None,
    contentTypeProfileConfig: Option[
      zio.aws.cloudfront.model.ContentTypeProfileConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfig = {
    import FieldLevelEncryptionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfig
      .builder()
      .callerReference(callerReference: java.lang.String)
      .optionallyWith(comment.map(value => value: java.lang.String))(_.comment)
      .optionallyWith(
        queryArgProfileConfig.map(value => value.buildAwsValue())
      )(_.queryArgProfileConfig)
      .optionallyWith(
        contentTypeProfileConfig.map(value => value.buildAwsValue())
      )(_.contentTypeProfileConfig)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.FieldLevelEncryptionConfig.ReadOnly =
    zio.aws.cloudfront.model.FieldLevelEncryptionConfig.wrap(buildAwsValue())
}
object FieldLevelEncryptionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.FieldLevelEncryptionConfig =
      zio.aws.cloudfront.model.FieldLevelEncryptionConfig(
        callerReference,
        comment.map(value => value),
        queryArgProfileConfig.map(value => value.asEditable),
        contentTypeProfileConfig.map(value => value.asEditable)
      )
    def callerReference: String
    def comment: Option[String]
    def queryArgProfileConfig
        : Option[zio.aws.cloudfront.model.QueryArgProfileConfig.ReadOnly]
    def contentTypeProfileConfig
        : Option[zio.aws.cloudfront.model.ContentTypeProfileConfig.ReadOnly]
    def getCallerReference: ZIO[Any, Nothing, String] =
      ZIO.succeed(callerReference)
    def getComment: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("comment", comment)
    def getQueryArgProfileConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.QueryArgProfileConfig.ReadOnly
    ] =
      AwsError.unwrapOptionField("queryArgProfileConfig", queryArgProfileConfig)
    def getContentTypeProfileConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ContentTypeProfileConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "contentTypeProfileConfig",
      contentTypeProfileConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfig
  ) extends zio.aws.cloudfront.model.FieldLevelEncryptionConfig.ReadOnly {
    override val callerReference: String = impl.callerReference(): String
    override val comment: Option[String] =
      scala.Option(impl.comment()).map(value => value: String)
    override val queryArgProfileConfig
        : Option[zio.aws.cloudfront.model.QueryArgProfileConfig.ReadOnly] =
      scala
        .Option(impl.queryArgProfileConfig())
        .map(value =>
          zio.aws.cloudfront.model.QueryArgProfileConfig.wrap(value)
        )
    override val contentTypeProfileConfig
        : Option[zio.aws.cloudfront.model.ContentTypeProfileConfig.ReadOnly] =
      scala
        .Option(impl.contentTypeProfileConfig())
        .map(value =>
          zio.aws.cloudfront.model.ContentTypeProfileConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfig
  ): zio.aws.cloudfront.model.FieldLevelEncryptionConfig.ReadOnly = new Wrapper(
    impl
  )
}
