package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Signer(
    awsAccountNumber: Option[String] = None,
    keyPairIds: Option[zio.aws.cloudfront.model.KeyPairIds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.Signer = {
    import Signer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.Signer
      .builder()
      .optionallyWith(awsAccountNumber.map(value => value: java.lang.String))(
        _.awsAccountNumber
      )
      .optionallyWith(keyPairIds.map(value => value.buildAwsValue()))(
        _.keyPairIds
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.Signer.ReadOnly =
    zio.aws.cloudfront.model.Signer.wrap(buildAwsValue())
}
object Signer {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.cloudfront.model.Signer] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.Signer =
      zio.aws.cloudfront.model.Signer(
        awsAccountNumber.map(value => value),
        keyPairIds.map(value => value.asEditable)
      )
    def awsAccountNumber: Option[String]
    def keyPairIds: Option[zio.aws.cloudfront.model.KeyPairIds.ReadOnly]
    def getAwsAccountNumber: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("awsAccountNumber", awsAccountNumber)
    def getKeyPairIds
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.KeyPairIds.ReadOnly] =
      AwsError.unwrapOptionField("keyPairIds", keyPairIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.Signer
  ) extends zio.aws.cloudfront.model.Signer.ReadOnly {
    override val awsAccountNumber: Option[String] =
      scala.Option(impl.awsAccountNumber()).map(value => value: String)
    override val keyPairIds
        : Option[zio.aws.cloudfront.model.KeyPairIds.ReadOnly] = scala
      .Option(impl.keyPairIds())
      .map(value => zio.aws.cloudfront.model.KeyPairIds.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.Signer
  ): zio.aws.cloudfront.model.Signer.ReadOnly = new Wrapper(impl)
}
