package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreatePublicKeyResponse(
    publicKey: Option[zio.aws.cloudfront.model.PublicKey] = None,
    location: Option[String] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyResponse = {
    import CreatePublicKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyResponse
      .builder()
      .optionallyWith(publicKey.map(value => value.buildAwsValue()))(
        _.publicKey
      )
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CreatePublicKeyResponse.ReadOnly =
    zio.aws.cloudfront.model.CreatePublicKeyResponse.wrap(buildAwsValue())
}
object CreatePublicKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreatePublicKeyResponse =
      zio.aws.cloudfront.model.CreatePublicKeyResponse(
        publicKey.map(value => value.asEditable),
        location.map(value => value),
        eTag.map(value => value)
      )
    def publicKey: Option[zio.aws.cloudfront.model.PublicKey.ReadOnly]
    def location: Option[String]
    def eTag: Option[String]
    def getPublicKey
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.PublicKey.ReadOnly] =
      AwsError.unwrapOptionField("publicKey", publicKey)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyResponse
  ) extends zio.aws.cloudfront.model.CreatePublicKeyResponse.ReadOnly {
    override val publicKey
        : Option[zio.aws.cloudfront.model.PublicKey.ReadOnly] = scala
      .Option(impl.publicKey())
      .map(value => zio.aws.cloudfront.model.PublicKey.wrap(value))
    override val location: Option[String] =
      scala.Option(impl.location()).map(value => value: String)
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyResponse
  ): zio.aws.cloudfront.model.CreatePublicKeyResponse.ReadOnly = new Wrapper(
    impl
  )
}
