package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait ReferrerPolicyList {
  def unwrap
      : software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList
}
object ReferrerPolicyList {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList
  ): zio.aws.cloudfront.model.ReferrerPolicyList = value match {
    case software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList.NO_REFERRER =>
      val r = `no-referrer`
      r
    case software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList.NO_REFERRER_WHEN_DOWNGRADE =>
      val r = `no-referrer-when-downgrade`
      r
    case software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList.ORIGIN =>
      val r = origin
      r
    case software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList.ORIGIN_WHEN_CROSS_ORIGIN =>
      val r = `origin-when-cross-origin`
      r
    case software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList.SAME_ORIGIN =>
      val r = `same-origin`
      r
    case software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList.STRICT_ORIGIN =>
      val r = `strict-origin`
      r
    case software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList.STRICT_ORIGIN_WHEN_CROSS_ORIGIN =>
      val r = `strict-origin-when-cross-origin`
      r
    case software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList.UNSAFE_URL =>
      val r = `unsafe-url`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.ReferrerPolicyList {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList =
      software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList.UNKNOWN_TO_SDK_VERSION
  }
  case object `no-referrer`
      extends zio.aws.cloudfront.model.ReferrerPolicyList {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList =
      software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList.NO_REFERRER
  }
  case object `no-referrer-when-downgrade`
      extends zio.aws.cloudfront.model.ReferrerPolicyList {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList =
      software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList.NO_REFERRER_WHEN_DOWNGRADE
  }
  case object origin extends zio.aws.cloudfront.model.ReferrerPolicyList {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList =
      software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList.ORIGIN
  }
  case object `origin-when-cross-origin`
      extends zio.aws.cloudfront.model.ReferrerPolicyList {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList =
      software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList.ORIGIN_WHEN_CROSS_ORIGIN
  }
  case object `same-origin`
      extends zio.aws.cloudfront.model.ReferrerPolicyList {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList =
      software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList.SAME_ORIGIN
  }
  case object `strict-origin`
      extends zio.aws.cloudfront.model.ReferrerPolicyList {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList =
      software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList.STRICT_ORIGIN
  }
  case object `strict-origin-when-cross-origin`
      extends zio.aws.cloudfront.model.ReferrerPolicyList {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList =
      software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList.STRICT_ORIGIN_WHEN_CROSS_ORIGIN
  }
  case object `unsafe-url` extends zio.aws.cloudfront.model.ReferrerPolicyList {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList =
      software.amazon.awssdk.services.cloudfront.model.ReferrerPolicyList.UNSAFE_URL
  }
}
