package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListStreamingDistributionsResponse(
    streamingDistributionList: Option[
      zio.aws.cloudfront.model.StreamingDistributionList
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse = {
    import ListStreamingDistributionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse
      .builder()
      .optionallyWith(
        streamingDistributionList.map(value => value.buildAwsValue())
      )(_.streamingDistributionList)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListStreamingDistributionsResponse.ReadOnly =
    zio.aws.cloudfront.model.ListStreamingDistributionsResponse
      .wrap(buildAwsValue())
}
object ListStreamingDistributionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListStreamingDistributionsResponse =
      zio.aws.cloudfront.model.ListStreamingDistributionsResponse(
        streamingDistributionList.map(value => value.asEditable)
      )
    def streamingDistributionList
        : Option[zio.aws.cloudfront.model.StreamingDistributionList.ReadOnly]
    def getStreamingDistributionList: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.StreamingDistributionList.ReadOnly
    ] = AwsError.unwrapOptionField(
      "streamingDistributionList",
      streamingDistributionList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse
  ) extends zio.aws.cloudfront.model.ListStreamingDistributionsResponse.ReadOnly {
    override val streamingDistributionList
        : Option[zio.aws.cloudfront.model.StreamingDistributionList.ReadOnly] =
      scala
        .Option(impl.streamingDistributionList())
        .map(value =>
          zio.aws.cloudfront.model.StreamingDistributionList.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse
  ): zio.aws.cloudfront.model.ListStreamingDistributionsResponse.ReadOnly =
    new Wrapper(impl)
}
