package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDistributionsByRealtimeLogConfigRequest(
    marker: Option[String] = None,
    maxItems: Option[String] = None,
    realtimeLogConfigName: Option[String] = None,
    realtimeLogConfigArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListDistributionsByRealtimeLogConfigRequest = {
    import ListDistributionsByRealtimeLogConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByRealtimeLogConfigRequest
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.String))(
        _.maxItems
      )
      .optionallyWith(
        realtimeLogConfigName.map(value => value: java.lang.String)
      )(_.realtimeLogConfigName)
      .optionallyWith(
        realtimeLogConfigArn.map(value => value: java.lang.String)
      )(_.realtimeLogConfigArn)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListDistributionsByRealtimeLogConfigRequest.ReadOnly =
    zio.aws.cloudfront.model.ListDistributionsByRealtimeLogConfigRequest
      .wrap(buildAwsValue())
}
object ListDistributionsByRealtimeLogConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByRealtimeLogConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListDistributionsByRealtimeLogConfigRequest =
      zio.aws.cloudfront.model.ListDistributionsByRealtimeLogConfigRequest(
        marker.map(value => value),
        maxItems.map(value => value),
        realtimeLogConfigName.map(value => value),
        realtimeLogConfigArn.map(value => value)
      )
    def marker: Option[String]
    def maxItems: Option[String]
    def realtimeLogConfigName: Option[String]
    def realtimeLogConfigArn: Option[String]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getRealtimeLogConfigName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("realtimeLogConfigName", realtimeLogConfigName)
    def getRealtimeLogConfigArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("realtimeLogConfigArn", realtimeLogConfigArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByRealtimeLogConfigRequest
  ) extends zio.aws.cloudfront.model.ListDistributionsByRealtimeLogConfigRequest.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxItems: Option[String] =
      scala.Option(impl.maxItems()).map(value => value: String)
    override val realtimeLogConfigName: Option[String] =
      scala.Option(impl.realtimeLogConfigName()).map(value => value: String)
    override val realtimeLogConfigArn: Option[String] =
      scala.Option(impl.realtimeLogConfigArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByRealtimeLogConfigRequest
  ): zio.aws.cloudfront.model.ListDistributionsByRealtimeLogConfigRequest.ReadOnly =
    new Wrapper(impl)
}
