package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait CachePolicyType {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.CachePolicyType
}
object CachePolicyType {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.CachePolicyType
  ): zio.aws.cloudfront.model.CachePolicyType = value match {
    case software.amazon.awssdk.services.cloudfront.model.CachePolicyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.CachePolicyType.MANAGED =>
      val r = managed
      r
    case software.amazon.awssdk.services.cloudfront.model.CachePolicyType.CUSTOM =>
      val r = custom
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.CachePolicyType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CachePolicyType =
      software.amazon.awssdk.services.cloudfront.model.CachePolicyType.UNKNOWN_TO_SDK_VERSION
  }
  case object managed extends zio.aws.cloudfront.model.CachePolicyType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CachePolicyType =
      software.amazon.awssdk.services.cloudfront.model.CachePolicyType.MANAGED
  }
  case object custom extends zio.aws.cloudfront.model.CachePolicyType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CachePolicyType =
      software.amazon.awssdk.services.cloudfront.model.CachePolicyType.CUSTOM
  }
}
