package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFieldLevelEncryptionProfileResponse(
    fieldLevelEncryptionProfile: Option[
      zio.aws.cloudfront.model.FieldLevelEncryptionProfile
    ] = None,
    location: Option[String] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse = {
    import CreateFieldLevelEncryptionProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse
      .builder()
      .optionallyWith(
        fieldLevelEncryptionProfile.map(value => value.buildAwsValue())
      )(_.fieldLevelEncryptionProfile)
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateFieldLevelEncryptionProfileResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateFieldLevelEncryptionProfileResponse
      .wrap(buildAwsValue())
}
object CreateFieldLevelEncryptionProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.CreateFieldLevelEncryptionProfileResponse =
      zio.aws.cloudfront.model.CreateFieldLevelEncryptionProfileResponse(
        fieldLevelEncryptionProfile.map(value => value.asEditable),
        location.map(value => value),
        eTag.map(value => value)
      )
    def fieldLevelEncryptionProfile
        : Option[zio.aws.cloudfront.model.FieldLevelEncryptionProfile.ReadOnly]
    def location: Option[String]
    def eTag: Option[String]
    def getFieldLevelEncryptionProfile: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.FieldLevelEncryptionProfile.ReadOnly
    ] = AwsError.unwrapOptionField(
      "fieldLevelEncryptionProfile",
      fieldLevelEncryptionProfile
    )
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse
  ) extends zio.aws.cloudfront.model.CreateFieldLevelEncryptionProfileResponse.ReadOnly {
    override val fieldLevelEncryptionProfile: Option[
      zio.aws.cloudfront.model.FieldLevelEncryptionProfile.ReadOnly
    ] = scala
      .Option(impl.fieldLevelEncryptionProfile())
      .map(value =>
        zio.aws.cloudfront.model.FieldLevelEncryptionProfile.wrap(value)
      )
    override val location: Option[String] =
      scala.Option(impl.location()).map(value => value: String)
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse
  ): zio.aws.cloudfront.model.CreateFieldLevelEncryptionProfileResponse.ReadOnly =
    new Wrapper(impl)
}
