package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class OriginRequestPolicyList(
    nextMarker: Option[String] = None,
    maxItems: Integer,
    quantity: Integer,
    items: Option[
      Iterable[zio.aws.cloudfront.model.OriginRequestPolicySummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyList = {
    import OriginRequestPolicyList.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyList
      .builder()
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .maxItems(Integer.unwrap(maxItems): java.lang.Integer)
      .quantity(Integer.unwrap(quantity): java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.OriginRequestPolicyList.ReadOnly =
    zio.aws.cloudfront.model.OriginRequestPolicyList.wrap(buildAwsValue())
}
object OriginRequestPolicyList {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyList
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.OriginRequestPolicyList =
      zio.aws.cloudfront.model.OriginRequestPolicyList(
        nextMarker.map(value => value),
        maxItems,
        quantity,
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[String]
    def maxItems: Integer
    def quantity: Integer
    def items: Option[
      List[zio.aws.cloudfront.model.OriginRequestPolicySummary.ReadOnly]
    ]
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getMaxItems: ZIO[Any, Nothing, Integer] = ZIO.succeed(maxItems)
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.OriginRequestPolicySummary.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyList
  ) extends zio.aws.cloudfront.model.OriginRequestPolicyList.ReadOnly {
    override val nextMarker: Option[String] =
      scala.Option(impl.nextMarker()).map(value => value: String)
    override val maxItems: Integer =
      zio.aws.cloudfront.model.primitives.Integer(impl.maxItems())
    override val quantity: Integer =
      zio.aws.cloudfront.model.primitives.Integer(impl.quantity())
    override val items: Option[
      List[zio.aws.cloudfront.model.OriginRequestPolicySummary.ReadOnly]
    ] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudfront.model.OriginRequestPolicySummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyList
  ): zio.aws.cloudfront.model.OriginRequestPolicyList.ReadOnly = new Wrapper(
    impl
  )
}
