package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EncryptionEntity(
    publicKeyId: String,
    providerId: String,
    fieldPatterns: zio.aws.cloudfront.model.FieldPatterns
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.EncryptionEntity = {
    import EncryptionEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.EncryptionEntity
      .builder()
      .publicKeyId(publicKeyId: java.lang.String)
      .providerId(providerId: java.lang.String)
      .fieldPatterns(fieldPatterns.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.EncryptionEntity.ReadOnly =
    zio.aws.cloudfront.model.EncryptionEntity.wrap(buildAwsValue())
}
object EncryptionEntity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.EncryptionEntity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.EncryptionEntity =
      zio.aws.cloudfront.model
        .EncryptionEntity(publicKeyId, providerId, fieldPatterns.asEditable)
    def publicKeyId: String
    def providerId: String
    def fieldPatterns: zio.aws.cloudfront.model.FieldPatterns.ReadOnly
    def getPublicKeyId: ZIO[Any, Nothing, String] = ZIO.succeed(publicKeyId)
    def getProviderId: ZIO[Any, Nothing, String] = ZIO.succeed(providerId)
    def getFieldPatterns
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.FieldPatterns.ReadOnly] =
      ZIO.succeed(fieldPatterns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.EncryptionEntity
  ) extends zio.aws.cloudfront.model.EncryptionEntity.ReadOnly {
    override val publicKeyId: String = impl.publicKeyId(): String
    override val providerId: String = impl.providerId(): String
    override val fieldPatterns
        : zio.aws.cloudfront.model.FieldPatterns.ReadOnly =
      zio.aws.cloudfront.model.FieldPatterns.wrap(impl.fieldPatterns())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.EncryptionEntity
  ): zio.aws.cloudfront.model.EncryptionEntity.ReadOnly = new Wrapper(impl)
}
