package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CookiePreference(
    forward: zio.aws.cloudfront.model.ItemSelection,
    whitelistedNames: Option[zio.aws.cloudfront.model.CookieNames] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CookiePreference = {
    import CookiePreference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CookiePreference
      .builder()
      .forward(forward.unwrap)
      .optionallyWith(whitelistedNames.map(value => value.buildAwsValue()))(
        _.whitelistedNames
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CookiePreference.ReadOnly =
    zio.aws.cloudfront.model.CookiePreference.wrap(buildAwsValue())
}
object CookiePreference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CookiePreference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CookiePreference =
      zio.aws.cloudfront.model.CookiePreference(
        forward,
        whitelistedNames.map(value => value.asEditable)
      )
    def forward: zio.aws.cloudfront.model.ItemSelection
    def whitelistedNames: Option[zio.aws.cloudfront.model.CookieNames.ReadOnly]
    def getForward: ZIO[Any, Nothing, zio.aws.cloudfront.model.ItemSelection] =
      ZIO.succeed(forward)
    def getWhitelistedNames
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.CookieNames.ReadOnly] =
      AwsError.unwrapOptionField("whitelistedNames", whitelistedNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CookiePreference
  ) extends zio.aws.cloudfront.model.CookiePreference.ReadOnly {
    override val forward: zio.aws.cloudfront.model.ItemSelection =
      zio.aws.cloudfront.model.ItemSelection.wrap(impl.forward())
    override val whitelistedNames
        : Option[zio.aws.cloudfront.model.CookieNames.ReadOnly] = scala
      .Option(impl.whitelistedNames())
      .map(value => zio.aws.cloudfront.model.CookieNames.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CookiePreference
  ): zio.aws.cloudfront.model.CookiePreference.ReadOnly = new Wrapper(impl)
}
