package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CachePolicyCookiesConfig(
    cookieBehavior: zio.aws.cloudfront.model.CachePolicyCookieBehavior,
    cookies: Option[zio.aws.cloudfront.model.CookieNames] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CachePolicyCookiesConfig = {
    import CachePolicyCookiesConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CachePolicyCookiesConfig
      .builder()
      .cookieBehavior(cookieBehavior.unwrap)
      .optionallyWith(cookies.map(value => value.buildAwsValue()))(_.cookies)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CachePolicyCookiesConfig.ReadOnly =
    zio.aws.cloudfront.model.CachePolicyCookiesConfig.wrap(buildAwsValue())
}
object CachePolicyCookiesConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CachePolicyCookiesConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CachePolicyCookiesConfig =
      zio.aws.cloudfront.model.CachePolicyCookiesConfig(
        cookieBehavior,
        cookies.map(value => value.asEditable)
      )
    def cookieBehavior: zio.aws.cloudfront.model.CachePolicyCookieBehavior
    def cookies: Option[zio.aws.cloudfront.model.CookieNames.ReadOnly]
    def getCookieBehavior: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.CachePolicyCookieBehavior
    ] = ZIO.succeed(cookieBehavior)
    def getCookies
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.CookieNames.ReadOnly] =
      AwsError.unwrapOptionField("cookies", cookies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CachePolicyCookiesConfig
  ) extends zio.aws.cloudfront.model.CachePolicyCookiesConfig.ReadOnly {
    override val cookieBehavior
        : zio.aws.cloudfront.model.CachePolicyCookieBehavior =
      zio.aws.cloudfront.model.CachePolicyCookieBehavior
        .wrap(impl.cookieBehavior())
    override val cookies
        : Option[zio.aws.cloudfront.model.CookieNames.ReadOnly] = scala
      .Option(impl.cookies())
      .map(value => zio.aws.cloudfront.model.CookieNames.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CachePolicyCookiesConfig
  ): zio.aws.cloudfront.model.CachePolicyCookiesConfig.ReadOnly = new Wrapper(
    impl
  )
}
