package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class Origin(
    id: String,
    domainName: String,
    originPath: Option[String] = None,
    customHeaders: Option[zio.aws.cloudfront.model.CustomHeaders] = None,
    s3OriginConfig: Option[zio.aws.cloudfront.model.S3OriginConfig] = None,
    customOriginConfig: Option[zio.aws.cloudfront.model.CustomOriginConfig] =
      None,
    connectionAttempts: Option[Integer] = None,
    connectionTimeout: Option[Integer] = None,
    originShield: Option[zio.aws.cloudfront.model.OriginShield] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.Origin = {
    import Origin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.Origin
      .builder()
      .id(id: java.lang.String)
      .domainName(domainName: java.lang.String)
      .optionallyWith(originPath.map(value => value: java.lang.String))(
        _.originPath
      )
      .optionallyWith(customHeaders.map(value => value.buildAwsValue()))(
        _.customHeaders
      )
      .optionallyWith(s3OriginConfig.map(value => value.buildAwsValue()))(
        _.s3OriginConfig
      )
      .optionallyWith(customOriginConfig.map(value => value.buildAwsValue()))(
        _.customOriginConfig
      )
      .optionallyWith(
        connectionAttempts.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.connectionAttempts)
      .optionallyWith(
        connectionTimeout.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.connectionTimeout)
      .optionallyWith(originShield.map(value => value.buildAwsValue()))(
        _.originShield
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.Origin.ReadOnly =
    zio.aws.cloudfront.model.Origin.wrap(buildAwsValue())
}
object Origin {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.cloudfront.model.Origin] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.Origin =
      zio.aws.cloudfront.model.Origin(
        id,
        domainName,
        originPath.map(value => value),
        customHeaders.map(value => value.asEditable),
        s3OriginConfig.map(value => value.asEditable),
        customOriginConfig.map(value => value.asEditable),
        connectionAttempts.map(value => value),
        connectionTimeout.map(value => value),
        originShield.map(value => value.asEditable)
      )
    def id: String
    def domainName: String
    def originPath: Option[String]
    def customHeaders: Option[zio.aws.cloudfront.model.CustomHeaders.ReadOnly]
    def s3OriginConfig: Option[zio.aws.cloudfront.model.S3OriginConfig.ReadOnly]
    def customOriginConfig
        : Option[zio.aws.cloudfront.model.CustomOriginConfig.ReadOnly]
    def connectionAttempts: Option[Integer]
    def connectionTimeout: Option[Integer]
    def originShield: Option[zio.aws.cloudfront.model.OriginShield.ReadOnly]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getDomainName: ZIO[Any, Nothing, String] = ZIO.succeed(domainName)
    def getOriginPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("originPath", originPath)
    def getCustomHeaders
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.CustomHeaders.ReadOnly] =
      AwsError.unwrapOptionField("customHeaders", customHeaders)
    def getS3OriginConfig
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.S3OriginConfig.ReadOnly] =
      AwsError.unwrapOptionField("s3OriginConfig", s3OriginConfig)
    def getCustomOriginConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.CustomOriginConfig.ReadOnly
    ] = AwsError.unwrapOptionField("customOriginConfig", customOriginConfig)
    def getConnectionAttempts: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("connectionAttempts", connectionAttempts)
    def getConnectionTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("connectionTimeout", connectionTimeout)
    def getOriginShield
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.OriginShield.ReadOnly] =
      AwsError.unwrapOptionField("originShield", originShield)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.Origin
  ) extends zio.aws.cloudfront.model.Origin.ReadOnly {
    override val id: String = impl.id(): String
    override val domainName: String = impl.domainName(): String
    override val originPath: Option[String] =
      scala.Option(impl.originPath()).map(value => value: String)
    override val customHeaders
        : Option[zio.aws.cloudfront.model.CustomHeaders.ReadOnly] = scala
      .Option(impl.customHeaders())
      .map(value => zio.aws.cloudfront.model.CustomHeaders.wrap(value))
    override val s3OriginConfig
        : Option[zio.aws.cloudfront.model.S3OriginConfig.ReadOnly] = scala
      .Option(impl.s3OriginConfig())
      .map(value => zio.aws.cloudfront.model.S3OriginConfig.wrap(value))
    override val customOriginConfig
        : Option[zio.aws.cloudfront.model.CustomOriginConfig.ReadOnly] = scala
      .Option(impl.customOriginConfig())
      .map(value => zio.aws.cloudfront.model.CustomOriginConfig.wrap(value))
    override val connectionAttempts: Option[Integer] = scala
      .Option(impl.connectionAttempts())
      .map(value => zio.aws.cloudfront.model.primitives.Integer(value))
    override val connectionTimeout: Option[Integer] = scala
      .Option(impl.connectionTimeout())
      .map(value => zio.aws.cloudfront.model.primitives.Integer(value))
    override val originShield
        : Option[zio.aws.cloudfront.model.OriginShield.ReadOnly] = scala
      .Option(impl.originShield())
      .map(value => zio.aws.cloudfront.model.OriginShield.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.Origin
  ): zio.aws.cloudfront.model.Origin.ReadOnly = new Wrapper(impl)
}
